// pelda1View.cpp : implementation of the CPelda1View class
//

#include "stdafx.h"
#include "pelda1.h"

#include "pelda1Doc.h"
#include "pelda1View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPelda1View

IMPLEMENT_DYNCREATE(CPelda1View, CView)

BEGIN_MESSAGE_MAP(CPelda1View, CView)
        //{{AFX_MSG_MAP(CPelda1View)
        ON_WM_DESTROY()
        ON_WM_CREATE()
	ON_WM_PAINT()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPelda1View construction/destruction

CPelda1View::CPelda1View()
	{
	// TODO: add construction code here
	m_hGLContext = NULL;
	m_GLPixelIndex = 0;
	}

CPelda1View::~CPelda1View()
	{
	}

BOOL CPelda1View::PreCreateWindow(CREATESTRUCT& cs)
	{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	cs.style |= (WS_CLIPCHILDREN | WS_CLIPSIBLINGS);
	return CView::PreCreateWindow(cs);
	}

/////////////////////////////////////////////////////////////////////////////
// CPelda1View drawing

void CPelda1View::OnDraw(CDC* pDC)
	{
	CPelda1Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	}

/////////////////////////////////////////////////////////////////////////////
// CPelda1View diagnostics

#ifdef _DEBUG
void CPelda1View::AssertValid() const
	{
	CView::AssertValid();
	}

void CPelda1View::Dump(CDumpContext& dc) const
	{
	CView::Dump(dc);
	}

CPelda1Doc* CPelda1View::GetDocument() // non-debug version is inline
	{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPelda1Doc)));
	return (CPelda1Doc*)m_pDocument;
	}
#endif //_DEBUG

//
// Pixelformtum beallitasa
//
BOOL CPelda1View::SetWindowPixelFormat(HDC hDC)
	{
	PIXELFORMATDESCRIPTOR pixelDesc;

	pixelDesc.nSize         = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion      = 1;

	pixelDesc.dwFlags       =       PFD_DRAW_TO_WINDOW |
											  PFD_SUPPORT_OPENGL |
											  PFD_STEREO_DONTCARE;

	pixelDesc.iPixelType            = PFD_TYPE_RGBA;
	pixelDesc.cColorBits            = 32;
	pixelDesc.cRedBits                      = 8;
	pixelDesc.cRedShift                     = 16;
	pixelDesc.cGreenBits            = 8;
	pixelDesc.cGreenShift           = 8;
	pixelDesc.cBlueBits                     = 8;
	pixelDesc.cBlueShift            = 0;
	pixelDesc.cAlphaBits            = 0;
	pixelDesc.cAlphaShift           = 0;
	pixelDesc.cAccumBits            = 64;
	pixelDesc.cAccumRedBits         = 16;
	pixelDesc.cAccumGreenBits       = 16;
	pixelDesc.cAccumBlueBits        = 16;
	pixelDesc.cAccumAlphaBits       = 0;
	pixelDesc.cDepthBits            = 32;
	pixelDesc.cStencilBits          = 8;
	pixelDesc.cAuxBuffers           = 0;
	pixelDesc.iLayerType            = PFD_MAIN_PLANE;
	pixelDesc.bReserved                     = 0;
	pixelDesc.dwLayerMask           = 0;
	pixelDesc.dwVisibleMask         = 0;
	pixelDesc.dwDamageMask          = 0;

	m_GLPixelIndex = ChoosePixelFormat(hDC,&pixelDesc);
     
	if (m_GLPixelIndex==0)
		{
		m_GLPixelIndex = 1;
		
		if (DescribePixelFormat( hDC, m_GLPixelIndex,
												sizeof(PIXELFORMATDESCRIPTOR),
												&pixelDesc) == 0)

			{
			return FALSE;
			}
		}

	  if (SetPixelFormat(hDC,m_GLPixelIndex,&pixelDesc) == FALSE)
			{
			return FALSE;
			}

	return TRUE;
	}

BOOL CPelda1View::CreateViewGLContext(HDC hDC)
	{
   m_hGLContext = wglCreateContext(hDC);
	
	if (m_hGLContext == NULL)
		{
		 //hiba tortent a create fuggvenynel
		 return FALSE;
		}

	if (wglMakeCurrent(hDC, m_hGLContext)==FALSE)
		{
		 //hiba tortent az aktualizalasnal
		 // ide johetnek hibakezelo reszek
		 return FALSE;
		}	
	//
	// minden OK!
	//
	return TRUE;
	}

void CPelda1View::OnDestroy()
	{
	if(wglGetCurrentContext() != NULL)
		{
		wglMakeCurrent(NULL, NULL);
		}
   
	if (m_hGLContext!=NULL)
		{
		wglDeleteContext(m_hGLContext);
		m_hGLContext = NULL;
		}

   CView::OnDestroy();
	}

int CPelda1View::OnCreate(LPCREATESTRUCT lpCreateStruct)	
	{
	if (CView::OnCreate(lpCreateStruct) == -1)
		{
		return -1;
		}

	HWND hWnd = GetSafeHwnd();
	HDC hDC = ::GetDC(hWnd);
	//
	// pixelformat beallitasa
	//
	if (SetWindowPixelFormat(hDC) == FALSE)
		{
		return 0;
		}
	//
	// a gl kontextus letrehozasa
	//
	if (CreateViewGLContext(hDC)==FALSE)
		{
		return 0;
		}
	return 0;
	}

void CPelda1View::OnSize(UINT nType, int cx, int cy)
	{
	CView::OnSize(nType, cx, cy);

	GLdouble aspect;
	GLsizei w,h;

	w = cx;
	h = cy;

	aspect = (GLdouble)w/(GLdouble)h;

	glViewport(0, 0, w, h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluOrtho2D(0.0, 100.0*aspect, 0.0, 100.0);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	}

void CPelda1View::OnPaint()
	{
	CPaintDC dc(this); // device context for painting

	glLoadIdentity();

	glClear(GL_COLOR_BUFFER_BIT);

	glBegin(GL_POLYGON);
	glColor4d(1.0,0.0,0.0,1.0);
	glVertex2d(50.0,20.0);

	glColor4d(0.0,0.0,1.0,1.0);
	glVertex2d(80.0,50.0);

	glColor4d(1.0,1.0,0.0,1.0);
	glVertex2d(60.0,60.0);

	glColor4d(1.0,0.0,1.0,1.0);
	glVertex2d(50.0,80.0);

	glColor4d(0.0,0.5,1.0,1.0);
	glVertex2d(40.0,60.0);

	glColor4d(5.0,0.5,0.0,1.0);
	glVertex2d(20.0,50.0);

	glEnd();

	glFlush();
	}



